/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.lang.reflect.Array;
import java.util.Locale;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleConvertUtils {
    private static Locale defaultLocale = Locale.getDefault();
    private static boolean applyLocalized = false;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$locale$LocaleConvertUtils == null ? (class$org$apache$commons$beanutils$locale$LocaleConvertUtils = LocaleConvertUtils.class$("org.apache.commons.beanutils.locale.LocaleConvertUtils")) : class$org$apache$commons$beanutils$locale$LocaleConvertUtils));
    private static FastHashMap mapConverters = new FastHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    static {
        LocaleConvertUtils.deregister();
    }

    public static void deregister() {
        FastHashMap defaultConverter = LocaleConvertUtils.lookup(defaultLocale);
        mapConverters.setFast(false);
        mapConverters.clear();
        mapConverters.put((Object)defaultLocale, (Object)defaultConverter);
        mapConverters.setFast(true);
    }

    public static boolean getApplyLocalized() {
        return applyLocalized;
    }

    public static void setApplyLocalized(boolean newApplyLocalized) {
        applyLocalized = newApplyLocalized;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void deregister(Locale locale) {
        mapConverters.remove((Object)locale);
    }

    public static void setDefaultLocale(Locale locale) {
        defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static String convert(Object value) {
        return LocaleConvertUtils.convert(value, defaultLocale, null);
    }

    public static void deregister(Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).remove((Object)clazz);
    }

    protected static FastHashMap create(Locale locale) {
        FastHashMap converter = new FastHashMap();
        converter.setFast(false);
        converter.put((Object)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LocaleConvertUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal), (Object)new BigDecimalLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LocaleConvertUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger), (Object)new BigIntegerLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Byte == null ? (class$java$lang$Byte = LocaleConvertUtils.class$("java.lang.Byte")) : class$java$lang$Byte), (Object)new ByteLocaleConverter(locale, applyLocalized));
        converter.put(Byte.TYPE, (Object)new ByteLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Double == null ? (class$java$lang$Double = LocaleConvertUtils.class$("java.lang.Double")) : class$java$lang$Double), (Object)new DoubleLocaleConverter(locale, applyLocalized));
        converter.put(Double.TYPE, (Object)new DoubleLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Float == null ? (class$java$lang$Float = LocaleConvertUtils.class$("java.lang.Float")) : class$java$lang$Float), (Object)new FloatLocaleConverter(locale, applyLocalized));
        converter.put(Float.TYPE, (Object)new FloatLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = LocaleConvertUtils.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)new IntegerLocaleConverter(locale, applyLocalized));
        converter.put(Integer.TYPE, (Object)new IntegerLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Long == null ? (class$java$lang$Long = LocaleConvertUtils.class$("java.lang.Long")) : class$java$lang$Long), (Object)new LongLocaleConverter(locale, applyLocalized));
        converter.put(Long.TYPE, (Object)new LongLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$Short == null ? (class$java$lang$Short = LocaleConvertUtils.class$("java.lang.Short")) : class$java$lang$Short), (Object)new ShortLocaleConverter(locale, applyLocalized));
        converter.put(Short.TYPE, (Object)new ShortLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String), (Object)new StringLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$sql$Date == null ? (class$java$sql$Date = LocaleConvertUtils.class$("java.sql.Date")) : class$java$sql$Date), (Object)new SqlDateLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$sql$Time == null ? (class$java$sql$Time = LocaleConvertUtils.class$("java.sql.Time")) : class$java$sql$Time), (Object)new SqlTimeLocaleConverter(locale, applyLocalized));
        converter.put((Object)(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LocaleConvertUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp), (Object)new SqlTimestampLocaleConverter(locale, applyLocalized));
        converter.setFast(true);
        return converter;
    }

    protected static FastHashMap lookup(Locale locale) {
        FastHashMap localeConverters;
        if (locale == null) {
            localeConverters = (FastHashMap)mapConverters.get((Object)defaultLocale);
        } else {
            localeConverters = (FastHashMap)mapConverters.get((Object)locale);
            if (localeConverters == null) {
                localeConverters = LocaleConvertUtils.create(locale);
                mapConverters.put((Object)locale, (Object)localeConverters);
            }
        }
        return localeConverters;
    }

    public static Object convert(String value, Class clazz) {
        return LocaleConvertUtils.convert(value, clazz, defaultLocale, null);
    }

    public static String convert(Object value, String pattern) {
        return LocaleConvertUtils.convert(value, defaultLocale, pattern);
    }

    public static void register(LocaleConverter converter, Class clazz, Locale locale) {
        LocaleConvertUtils.lookup(locale).put((Object)clazz, (Object)converter);
    }

    public static LocaleConverter lookup(Class clazz, Locale locale) {
        return (LocaleConverter)LocaleConvertUtils.lookup(locale).get((Object)clazz);
    }

    public static Object convert(String value, Class clazz, String pattern) {
        return LocaleConvertUtils.convert(value, clazz, defaultLocale, pattern);
    }

    public static Object convert(String[] values, Class clazz, String pattern) {
        return LocaleConvertUtils.convert(values, clazz, LocaleConvertUtils.getDefaultLocale(), pattern);
    }

    public static String convert(Object value, Locale locale, String pattern) {
        LocaleConverter converter = LocaleConvertUtils.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, locale);
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, value, pattern);
    }

    public static Object convert(String value, Class clazz, Locale locale, String pattern) {
        LocaleConverter converter;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert string " + value + " to class " + clazz.getName() + " using " + locale.toString() + " locale and " + pattern + " pattern"));
        }
        if ((converter = LocaleConvertUtils.lookup(clazz, locale)) == null) {
            converter = LocaleConvertUtils.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtils.class$("java.lang.String")) : class$java$lang$String, locale);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Using converter " + converter));
        }
        return converter.convert(clazz, value, pattern);
    }

    public static Object convert(String[] values, Class clazz, Locale locale, String pattern) {
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale.toString() + " locale and " + pattern + " pattern"));
        }
        Object array = Array.newInstance(type, values.length);
        int i = 0;
        while (i < values.length) {
            Array.set(array, i, LocaleConvertUtils.convert(values[i], type, locale, pattern));
            ++i;
        }
        return array;
    }
}

